#if !defined(CHARUI_HPP)
#define CHARUI_HPP

#include "misc.hpp"
#include "brdsize.hpp"

// lowest layer of user interface
class CHARUSERIFACE
  {
  private:
    uint cursorMode;

  public:
    CHARUSERIFACE(void);
    ~CHARUSERIFACE(void);

    CLASSMEMBER void clearScreen(void);

    // show a character on the screen
    CLASSMEMBER void showChar
      (
	// position to show the character at
        int row, int col,
        // character to show
        char c,
	// display character in inverse-video?
        BOOL inverse
      );
	
    CLASSMEMBER void showChar(POSITION p, char c, BOOL inverse)
      { showChar(p.row, p.col, c, inverse); return; }

    // wait for key press by user, return its code.  codes are
    // ASCII codes for characters corresponding to keys, except for
    // those listed below.
    CLASSMEMBER uint readKey(void);
  };

// codes for non-character keys
const uint KEYESC = 0x001B;
const uint KEYENTER = 0x000D;
const uint KEYUP = (72 << 8);
const uint KEYDOWN = (80 << 8);
const uint KEYLEFT = (75 << 8);
const uint KEYRIGHT = (77 << 8);

// only instance of this class
extern CHARUSERIFACE CharUI;

#endif
